/******************************************************************************
 * %Id: ipr_bridge_data.h,v 1.35 2010/02/15 06:26:20 ishikawa Exp $
 *
 * FileName		:vop_bridge_data.h
 *
 * Description	:Data definition header for bridge
 *
 *
 * Copyright	:Panasonic Corporation.
 *
 *****************************************************************************/
#ifndef	_VOP_BRIDGE_DATA_H_
#define	_VOP_BRIDGE_DATA_H_

#include <linux/iosc/iosc-devices.h>


/* event handler table */
typedef struct {
	int	cmd;
	int	(*handler)(int, unsigned int, void *);
} vop_command_t;


/**********/
/* struct */
/**********/
typedef int    VOP_FIX16;  /* Definition of fixed decimal point type */

typedef enum {
    VOP_L_INTR_VSYNC  = 0x00000001UL,	/* Vertical sync    */
    VOP_L_INTR_DETECT = 0x00000002UL,	/* detect end       */
    VOP_L_INTR_ADAPT  = 0x00000004UL,	/* adapt calc end   */
} vop_intr_t;

typedef struct {
	unsigned short		offset_h;	/* horizontal start position */
	unsigned short		wide_h; 	/* horizontal width          */
	unsigned short		offset_v;	/* vertical start position   */
	unsigned short		wide_v; 	/* vertical width            */
} vop_window_t;

typedef struct {
	unsigned short		pede;   	/* pedestal level             */
	unsigned char		scene_th;	/* scene change apl threshold */
	unsigned char		hst_mode;	/* histogram processing mode  */
	unsigned char		black_fil;	/* black area filter coef     */
	unsigned char		white_fil;	/* white area filter coef     */
	unsigned char		min_fil;	/* min filter coef            */
	unsigned char		max_fil;	/* max filter coef            */
	unsigned char		apl_fil;	/* apl filter coef            */
	unsigned char		hst_fil;	/* histogram filter coef       */
} vop_adapt_common_t;

typedef struct {
	unsigned char		black_limit;	/* limiter of black area                 */
	unsigned char		black_y_th; 	/* threshold of black level              */
	unsigned char		white_limit;	/* limiter of white area                 */
	unsigned char		white_y_th;		/* threshold of white level              */
	unsigned char		skin_h_start;	/* lower limit (hue) of skin area        */
	unsigned char		skin_h_end; 	/* upper limit (hue) of skin area        */
	unsigned char		skin_s_start;	/* lower limit (saturation) of skin area */
	unsigned char		skin_s_end; 	/* upper limit (saturation) of skin area */
	unsigned char		skin_v_start;	/* lower limit (value) of skin area      */
	unsigned char		skin_v_end; 	/* upper limit (value) of skin area      */
	unsigned char		skin_test;  	/* on flag of skin test                  */
} vop_area_param_t;

typedef struct {
	unsigned short		ymin;   	/* min      */
	unsigned short		ymax;   	/* max      */
	unsigned short		yapl;   	/* apl      */
	unsigned short		yhst[16];	/* histogram */
} vop_adapt_detect_t;

typedef struct {
	unsigned short		black_area;	/* black area */
	unsigned short		white_area;	/* white area */
	unsigned long 		skin_area;	/* skin area  */
} vop_area_detect_t;

typedef struct {
	unsigned short		bin1_start;	/* bin1 histogram start luminance */
	unsigned short		bin1_end;	/* bin1 histogram end luminance */
	unsigned short		bin2_start;	/* bin2 histogram start luminance */
	unsigned short		bin2_end;	/* bin2 histogram end luminance */
} vop_2binhst_param_t;

typedef struct {
	unsigned long		bin1_hst;	/* bin1 histogram */
	unsigned long		bin2_hst;	/* bin2 histogram */
} vop_2binhst_detect_t;

typedef struct {
	unsigned char		ofs[8];   	/* offset gamma */
	unsigned char		lmt_upp[8];	/* upper limit  */
	unsigned char		lmt_low[8];	/* lower limit  */
	unsigned short		gain;   	/* gain         */
	unsigned char		gain_ctrl;	/* histogram decentralization */
	unsigned char		maxmin_gain;	/* gain   of histogram decentralization  */
	unsigned char		maxmin_offset;	/* offset of histogram decentralization  */
} vop_adapt_hst_t;

typedef struct {
	unsigned short		lut[16];
} vop_manual_hst_t;

typedef struct {
	unsigned char		gain[16];
} vop_manual_yc_t;

typedef struct {
	unsigned char		gain_high;  	/* gain(high)               */
	unsigned char		gain_low;   	/* gain(low)                */
	unsigned char		apl_th;     	/* apl threshold            */
	unsigned char		coef_high[8];	/* effect coefficient(high) */
	unsigned char		coef_low[8];	/* effect coefficient(low)  */
} vop_adapt_gamma_t;

typedef struct {
	unsigned char		start;	/* start point */
	unsigned char		end;	/* end point   */
	unsigned char		gain_u;	/* upper gain  */
	unsigned char		gain_d;	/* lower gain  */
	unsigned char		limit;	/* gain limit  */
} vop_adapt_crt_t;

typedef struct {
	unsigned char		start_high;	/* color up apl threshold   */
	unsigned char		start_low;	/* color down apl threshold */
	unsigned char		gain_high;	/* color up gain            */
	unsigned char		gain_low;	/* color down gain          */
	unsigned char		lmt_high;	/* color up limit           */
	unsigned char		lmt_low;	/* color down limit         */
} vop_adapt_color_t;

typedef struct {
	unsigned char		lmt_upp;	/* upper limit */
	unsigned char		lmt_low;	/* lower limit */
	unsigned char		gain;   	/* gain        */
} vop_adapt_yc_t;

typedef struct {
	unsigned char		gain[16];	/* adapt result gain */
} vop_adapt_gain_t;

typedef struct {
	unsigned short		start;  	/* start point                             */
	unsigned char		gain;   	/* gain                                    */
	unsigned char		fb_gain;	/* feedback gain by low apl                */
	unsigned short		fb_th;  	/* low apl threshold                       */
	unsigned short		limit;  	/* limit                                   */
	unsigned char		select;  	/* selection min/apl                       */
	unsigned char		skin_gain;	/* feedback gain by skin area              */
	unsigned char		skin_th;	/* threshold of feedback gain by skin area */
	unsigned char		area_gain;	/* feedback gain by black area             */
	unsigned char		hst_gain;	/* feedback gain by histogram              */
	unsigned char		hst_sl;  	/* select feedback histogram area          */
	unsigned char		lpf_tab;
} vop_yblack_t;

typedef struct {
	unsigned short		start;	/* gamma bend point */
	unsigned char		gain;	/* gamma gain       */
} vop_red_gamma_t;

typedef struct {
	unsigned char		ypkinv;   	/* enhancer(low,high,v) inverse effect  */
} vop_enh_common_t;

typedef struct {
	unsigned char		edge_hst[9];	/* edge histgram */
} vop_edge_hst_t;

typedef struct {
	unsigned char		sat_hst[9];	/* saturation histgram */
} vop_sat_hst_t;

typedef struct {
	unsigned char		h_edge_sel;		/* h_edge histogram select     */
	unsigned short		h_edge_core;	/* h_edge histogram coring     */
	unsigned char		v_edge_sel;		/* v_edge histogram select     */
	unsigned short		v_edge_core;	/* v_edge histogram coring     */
	unsigned char		sat_sel;		/* saturation histogram select */
	unsigned short		sat_core;		/* saturation histogram coring */
} vop_srhst_param_t;

typedef struct {
	unsigned char		gain_p; 	/* plus gain     */
	unsigned char		gain_m; 	/* minus gain    */
	unsigned char		limit_p;	/* puls limiter  */
	unsigned char		limit_m;	/* minus limiter */
	unsigned char		core;   	/* coring        */
	unsigned char		bpfsl;  	/* bp filter     */
} vop_enh_ypk_t;

typedef struct {
	unsigned char		gain_a;	/* upper gain */
	unsigned char		gain_b;	/* lower gain */
	unsigned short		lmt_a;	/* start gain */
	unsigned char		lmt_b;	/* end gain   */
	unsigned short		lmt_c;	/* limit      */
	unsigned char		core;	/* coring     */
	unsigned char		tap;	/* filter tap */
} vop_enh_yti_t;

typedef vop_enh_yti_t vop_enh_cti_t;

typedef struct {
	unsigned char		gain_a;	/* upper gain */
	unsigned char		gain_b;	/* lower gain */
	unsigned char		lmt_a;	/* start gain */
	unsigned char		lmt_b;	/* end gain   */
	unsigned char		lmt_d;	/* limit      */
	unsigned char		core;	/* coring     */
} vop_dypk_gain_t;

typedef struct {
	vop_dypk_gain_t		edge_low_h; 	/* edge adapt (h_low)          */
	vop_dypk_gain_t		edge_high_h;	/* edge adapt (h_high)         */
	vop_dypk_gain_t		lumi_h;     	/* luminance adapt(horizontal) */
	vop_dypk_gain_t		edge_v;     	/* edge adapt (vertial)        */
	vop_dypk_gain_t		lumi_v;     	/* luminance adapt(vertical)   */
} vop_dypk_t;

typedef struct {
	unsigned short		w_thin;	/* white thinning  */
	unsigned char		round;	/* round edge      */
} vop_dyti_gain_t;

typedef struct {
	vop_dyti_gain_t		h;
	vop_dyti_gain_t		v;
} vop_dyti_t;

typedef struct {
	vop_window_t	win;	/* window position */
	unsigned char		wininv;     	/* window inverse  */
} vop_enh_window_t;

typedef vop_enh_window_t vop_col_window_t;

typedef struct {
	unsigned char		main_on;	/* main termination onoff */
	unsigned char		sub_on; 	/* sub termination onoff */
	unsigned char		pip_mode;	/* pop/pip */
	unsigned char		act_mode;	/* active signal select auto/manual */
} vop_enhrep_t;

typedef vop_enhrep_t vop_actwin_t;

typedef struct {
	unsigned char		edge;
	unsigned char		gain;
	unsigned char		bpfsl;
}vop_smooth_gain_t;

typedef struct {
 	vop_smooth_gain_t 	low_h;
 	vop_smooth_gain_t 	high_h;
 	vop_smooth_gain_t 	v;
}vop_smooth_t;

typedef struct {
	unsigned char	lpfsl;			/* lpf type */
	unsigned char	degree;			/* gain angle of edge */
	unsigned short	lmt;			/* lpf limiter */
} vop_smooth_lpf_t;

typedef struct {
	unsigned char		mode;	/* select smooth type. Normal(BPF) or LPF. */
	vop_smooth_lpf_t	h;		/* h lpf parameter */
	vop_smooth_lpf_t	v;		/* v lpf parameter */
} vop_smooth_mode_t;

typedef struct {
	unsigned short		slice;  	/* slice level       */
	unsigned char		gain;   	/* gain              */
	unsigned short		apl_th; 	/* apl threshold     */
	unsigned char		apl_gain;	/* apl feedback gain */
	unsigned short		slice_max;	/* slice level limit */
} vop_wch_t;

typedef struct {
	signed int	ry_axis;	/* r-y axis  */
	signed int	by_axis;	/* b-y axis  */
	signed int	gy_axis;	/* g-y axis  */
	signed int	ry_axis2;	/* r-y axis2 */
	signed int	by_axis2;	/* b-y axis2 */
	signed int	gy_axis2;	/* g-y axis2 */
} vop_mtx_axis_t;

typedef struct {
	signed char	tint;   	/* tint        */
	unsigned short		color;      	/* color level */
	vop_mtx_axis_t	axis;	/* demod axis  */
	unsigned char		ry_gain;    	/* r-y gain    */
	unsigned char		by_gain;    	/* b-y gain    */
	unsigned char		gy_gain1;   	/* g-y gain1   */
	unsigned char		gy_gain2;   	/* g-y gain2   */
} vop_mtx_t;

typedef struct {
	unsigned short		ic00;
	unsigned short		ic01;
	unsigned short		ic10;
	unsigned short		ic11;
	unsigned short		ic20;
	unsigned short		ic21;
} vop_mtx_coefficient_t;

/*******************************************************/
/*  matrix of rgb color transfomation                  */
/* : matrix coefficient                                */
/*     |r2| | a00(a[0])  a01(a[1])  a02(a[2]) | |r1|   */
/*     |g2|=| a10(a[3])  a11(a[4])  a12(a[5]) |.|g1|   */
/*     |b2| | a20(a[6])  a21(a[7])  a22(a[8]) | |b1|   */
/* set by twos complement                              */
/*    [-2.0 : +1.999] -> [2048 : 2047]                 */
/*******************************************************/
typedef struct {
	unsigned short		a[9];
} vop_col_mtx_t;

typedef struct {
	unsigned char		h_ofs_pm;	/* hue offset polarity */
	unsigned short		h_ofs;  	/* hue offset          */
	unsigned short		s_gain; 	/* saturation gain     */
	unsigned short		v_gain; 	/* value gain          */
} vop_6axis_hsv_t;

typedef struct {
	vop_6axis_hsv_t		axis[6];
} vop_6axis_t;

typedef struct {
	unsigned short		ofs;	/* threshold */
	unsigned char		gain;	/* gain      */
	unsigned char		range;	/* unused */
} vop_6axis_v_limit_t;

typedef struct {
	unsigned char		h_range;		/* Hue range selector */
	unsigned short		h_ofs120[6];	/* Hue offset for 120 degree mode */
	unsigned char		sv_range;		/* Saturation,Value range selector */
	unsigned char		degree_ofs[6];	/* degree for SV range adjust mode */
} vop_6axis_range_t;

typedef struct {
	char		h_ofs;  	/* hue offset          */
	unsigned char		s_gain; 	/* saturation gain     */
} vop_v6axis_hs_t;

typedef struct {
	vop_v6axis_hs_t		low;	/* low value */
	vop_v6axis_hs_t		middle;	/* middle value */
	vop_v6axis_hs_t		high;	/* high value */
} vop_v6axis_gain_t;

typedef struct {
	vop_v6axis_gain_t	axis[6];	/* 6 colors */
} vop_v6axis_t;

typedef struct {
	unsigned short offset;
	unsigned short wide;
	unsigned char gain1;
	unsigned char gain2;
}vop_selcol_area_t;

typedef struct {
	vop_selcol_area_t	area_h;
	vop_selcol_area_t	area_s;
	vop_selcol_area_t	area_v;
	unsigned short					effect_h;
	unsigned short					effect_s;
	unsigned short					effect_v;
}vop_selcol_hsv_t;

typedef struct {
	vop_selcol_hsv_t		axis[8];
} vop_selcol_t;

typedef struct {
	signed int	tint;	/* tint        */
	unsigned short			color;	/* color level */
}vop_hsvcol_t;

typedef struct {
	unsigned char		polar;	/* polarity  */
	unsigned char		gain;	/* gain      */
	unsigned char		start;	/* start apl */
	unsigned char		end;	/* stop apl  */
	unsigned short		limit;	/* limit     */
} vop_dc_t;

typedef struct {
	unsigned short		r;	/* red   */
	unsigned short		g;	/* green */
	unsigned short		b;	/* blue  */
} vop_rgb_t;

typedef struct {
	vop_rgb_t	drive;	/* rgb gain   */
	vop_rgb_t	cutoff;	/* rgb offset */
} vop_col_temp_t;

typedef struct {
	unsigned char		bit_num;	/* output bit             */
	unsigned char		osd_on; 	/* losd ns on/off         */
	unsigned char		dns_on;   	/* addition random number */
} vop_ns_t;

typedef struct {
	signed int	offset_h;	/* horizontal start position */
	unsigned short    		wide_h;  	/* horizontal width          */
	signed int	offset_v;	/* vertical start position   */
	unsigned short    		wide_v;  	/* vertical width            */
	unsigned char    		polar;  	/* polarity                  */
} vop_pulse_t;

typedef struct {
	unsigned short		hdiv;	/* divider of pulse period */
	unsigned short		vdiv;	/* divider of pulse period */
	unsigned short		duty;	/* duty                    */
	unsigned short		duty_hdiv;	/* duty unit           */
	unsigned char		mode;	/* reset v-sync mode       */
	unsigned short		delay;	/* reset v-sync delay      */
	unsigned short		delay_hdiv;	/* delay unit          */
} vop_blpwm_t;


typedef void (*vop_intrproc_t)(void); /* vop interrupt service routine */ 


typedef struct {
	vop_rgb_t 	col;
} vop_probe_data_t;

typedef struct {
	unsigned short h_pos;
	unsigned short v_pos;
}vop_probe_pos_t;

typedef struct {
	unsigned short	offset_x;
	unsigned short	offset_y;
	unsigned short	act_h;
	unsigned short	act_v;
	unsigned char	color_form;
} vop_format_t;

typedef struct {
	vop_format_t	in;
	vop_format_t	out;
	unsigned int	signal_form;
} vop_signal_form_t;

typedef vop_yblack_t vop_ywhite_t;

typedef struct {
	vop_selcol_area_t	area_h;
	vop_selcol_area_t	area_s;
	vop_selcol_area_t	area_v;
	unsigned char		gain;
}vop_sel_effect_t;

typedef struct {
	vop_sel_effect_t	skin;
	vop_sel_effect_t	blue;
	unsigned char		test_on;
} vop_seladapt_t;

typedef vop_seladapt_t vop_selenh_t;

typedef struct {
	unsigned short	y_edge_end;
	unsigned char	y_edge_end_gain;
	unsigned short	c_edge_core;
	unsigned char	c_edge_gain;
} vop_dcnr_t;

typedef struct {
	unsigned char data;	/* tentative */
} vopld_panel_info_t;

typedef struct {
	unsigned char data;	/* tentative */
} vopld_spi_form_t;

typedef struct {
	unsigned char data;	/* tentative */
} vopld_ctrl_t;

typedef struct {
	unsigned char data;	/* tentative */
} vopld_rgb_t;

typedef struct {
	unsigned char	coef[8];
	vop_enh_ypk_t	effect;
	vop_dypk_gain_t	edge_diag;	/* edge adapt (diagonal)     */
	vop_dypk_gain_t	lumi_diag;	/* luminance adapt(diagonal) */
}vop_diag_ypk_t;

typedef struct {
	unsigned long		freq_hst[1];	/* frequency histgram */
} vop_freq_hst_t;

typedef struct {
	unsigned char		freq_core;	/* frequency histogram coring    */
	unsigned char		freq_th;	/* frequency histogram threshold */
} vop_freqhst_param_t;

typedef struct {
	unsigned char bit_num;		/* output bits     */
	unsigned char mode;			/* FRC Dither mode */
} vop_frc_dither_t;

typedef struct {
	unsigned short pattern01[4];	/* FRC Dither pattern01's frame1~4 */
	unsigned short pattern10[4];	/* FRC Dither pattern10's frame1~4 */
	unsigned short pattern11[4];	/* FRC Dither pattern11's frame1~4 */
} vop_frc_dither_pattern_t;

typedef struct {
	vop_frc_dither_pattern_t r;		/* red   parameter */
	vop_frc_dither_pattern_t g;		/* green parameter */
	vop_frc_dither_pattern_t b;		/* blue  parameter */
} vop_frc_dither_lut_t;

/*******************/
/* API args struct */
/*******************/
typedef struct {
	int	error;
} vop_void_arg_t;

typedef vop_void_arg_t		vop_init_arg_t;
typedef vop_void_arg_t		vop_term_arg_t;

typedef struct _vop_reg_update_mode_arg_t {
	int	error;
	unsigned char	mode;
} vop_reg_update_mode_arg_t;

typedef struct _vop_detect_window_arg_t {
	int	error;
	unsigned char	onoff;
	vop_window_t	data;
} vop_detect_window_arg_t;

typedef struct _vop_adapt_common_arg_t {
	int	error;
	vop_adapt_common_t	data;
} vop_adapt_common_arg_t;

typedef struct _vop_area_detect_param_arg_t {
	int	error;
	vop_area_param_t	data;
} vop_area_detect_param_arg_t;

typedef struct _vop_adapt_detect_arg_t {
	int	error;
	vop_adapt_detect_t	data;
} vop_adapt_detect_arg_t;


typedef struct _vop_area_detect_arg_t {
	int	error;
	vop_area_detect_t	data;
} vop_area_detect_arg_t;

typedef struct _vop_2bin_histo_param_arg_t {
	int	error;
	vop_2binhst_param_t	data;
} vop_2bin_histo_param_arg_t;

typedef struct _vop_2bin_histo_arg_t {
	int	error;
	vop_2binhst_detect_t	data;
} vop_2bin_histo_arg_t;

typedef struct _vop_adapt_block_arg_t {
	int	error;
	unsigned char	onoff;
} vop_adapt_block_arg_t;

typedef struct _vop_adapt_hst_arg_t {
	int	error;
	unsigned char	onoff;
	vop_adapt_hst_t	data;
} vop_adapt_hst_arg_t;

typedef struct _vop_manual_hst_arg_t {
	int	error;
	unsigned char	onoff;
	vop_manual_hst_t	data;
} vop_manual_hst_arg_t;

typedef struct _vop_adapt_gamma_arg_t {
	int	error;
	unsigned char	onoff;
	vop_adapt_gamma_t	data;
} vop_adapt_gamma_arg_t;

typedef struct _vop_adapt_crt_arg_t {
	int	error;
	unsigned char	onoff;
	vop_adapt_crt_t	data;
} vop_adapt_crt_arg_t;

typedef struct _vop_adapt_color_arg_t {
	int	error;
	unsigned char	onoff;
	vop_adapt_color_t	data;
} vop_adapt_color_arg_t;

typedef struct _vop_adapt_yc_arg_t {
	int	error;
	unsigned char	onoff;
	vop_adapt_yc_t	data;
} vop_adapt_yc_arg_t;

typedef struct _vop_manual_yc_arg_t {
	int	error;
	unsigned char	onoff;
	vop_manual_yc_t	data;
} vop_manual_yc_arg_t;

typedef struct _vop_adapt_window_arg_t {
	int	error;
	unsigned char	onoff;
	vop_window_t	data;
} vop_adapt_window_arg_t;

typedef struct _vop_adapt_gain_arg_t {
	int	error;
	vop_adapt_gain_t	data;
} vop_adapt_gain_arg_t;

typedef struct _vop_yblack_arg_t {
	int	error;
	unsigned char	onoff;
	vop_yblack_t	data;
} vop_yblack_arg_t;

typedef struct _vop_red_gamma_arg_t {
	int	error;
	unsigned char	onoff;
	vop_red_gamma_t	data;
} vop_red_gamma_arg_t;

typedef struct _vop_enhance_block_arg_t {
	int	error;
	unsigned char	onoff;
} vop_enhance_block_arg_t;

typedef struct _vop_enhance_common_arg_t {
	int	error;
	vop_enh_common_t	data;
} vop_enhance_common_arg_t;

typedef struct _vop_edge_hst_arg_t {
	int	error;
	vop_edge_hst_t	data;
} vop_edge_hst_arg_t;

typedef struct _vop_sat_hst_arg_t {
	int	error;
	vop_sat_hst_t	data;
} vop_sat_hst_arg_t;

typedef struct _vop_srhst_param_arg_t {
	int	error;
	vop_srhst_param_t	data;
} vop_srhst_param_arg_t;

typedef struct _vop_ypk_low_arg_t {
	int	error;
	unsigned char	onoff;
	vop_enh_ypk_t	data;
} vop_ypk_low_arg_t;

typedef struct _vop_ypk_high_arg_t {
	int	error;
	unsigned char	onoff;
	vop_enh_ypk_t	data;
} vop_ypk_high_arg_t;

typedef struct _vop_yti_arg_t {
	int	error;
	unsigned char	onoff;
	vop_enh_yti_t	data;
} vop_yti_arg_t;

typedef struct _vop_vpk_arg_t {
	int	error;
	unsigned char	onoff;
	vop_enh_ypk_t	data;
} vop_vpk_arg_t;

typedef struct _vop_vyti_arg_t {
	int	error;
	unsigned char	onoff;
	vop_enh_yti_t	data;
} vop_vyti_arg_t;

typedef struct _vop_cti_arg_t {
	int	error;
	unsigned char	onoff;
	vop_enh_cti_t	data;
} vop_cti_arg_t;

typedef struct _vop_dynamic_ypk_arg_t {
	int	error;
	vop_dypk_t	data;
} vop_dynamic_ypk_arg_t;

typedef struct _vop_dynamic_yti_arg_t {
	int	error;
	unsigned char	onoff;
	vop_dyti_t	data;
} vop_dynamic_yti_arg_t;

typedef struct _vop_enhance_window_arg_t {
	int	error;
	vop_enh_window_t	data;
} vop_enhance_window_arg_t;

typedef struct _vop_enhance_repeat_window_arg_t {
	int	error;
	vop_window_t	main;
	vop_window_t	sub;
	vop_enhrep_t	mode;
} vop_enhance_repeat_window_arg_t;

typedef struct _vop_smooth_arg_t {
	int	error;
	unsigned char	onoff;
	vop_smooth_t	data;
} vop_smooth_arg_t;

typedef struct _vop_smooth_mode_arg_t {
	int	error;
	vop_smooth_mode_t	data;
} vop_smooth_mode_arg_t;

typedef struct _vop_wch_arg_t {
	int	error;
	unsigned char	onoff;
	vop_wch_t	data;
} vop_wch_arg_t;

typedef struct _vop_matrix_arg_t {
	int	error;
	vop_mtx_t	data;
} vop_matrix_arg_t;

typedef struct _vop_matrix_coefficient_arg_t {
	int	error;
	vop_mtx_coefficient_t	data;
} vop_matrix_coefficient_arg_t;

typedef struct _vop_rgb_pede_arg_t {
	int	error;
	unsigned short	level;
} vop_rgb_pede_arg_t;

typedef struct _vop_color_matrix_arg_t {
	int	error;
	unsigned char	onoff;
	vop_col_mtx_t	data;
} vop_color_matrix_arg_t;

typedef struct _vop_6axis_arg_t {
	int	error;
	unsigned char	onoff;
	vop_6axis_t	data;
} vop_6axis_arg_t;

typedef struct _vop_6axis_v_limit_arg_t {
	int	error;
	vop_6axis_v_limit_t	data;
} vop_6axis_v_limit_arg_t;

typedef struct _vop_6axis_range_arg_t {
	int	error;
	vop_6axis_range_t	data;
} vop_6axis_range_arg_t;

typedef struct _vop_vadapt_6axis_arg_t {
	int	error;
	unsigned char	onoff;
	vop_v6axis_t	data;
} vop_vadapt_6axis_arg_t;

typedef struct _vop_selective_color_arg_t {
	int	error;
	unsigned char	onoff;
	vop_selcol_t	data;
} vop_selective_color_arg_t;

typedef struct _vop_hsv_color_arg_t {
	int	error;
	unsigned char	onoff;
	vop_hsvcol_t	data;
} vop_hsv_color_arg_t;

typedef struct _vop_color_window_arg_t {
	int	error;
	vop_col_window_t	data;
} vop_color_window_arg_t;

typedef struct _vop_yuv_block_arg_t {
	int	error;
	unsigned char	onoff;
} vop_yuv_block_arg_t;

typedef struct _vop_level_arg_t {
	int	error;
	unsigned short	contrast;
	unsigned short	brightness;
} vop_level_arg_t;

typedef struct _vop_dc_arg_t {
	int	error;
	unsigned char	onoff;
	vop_dc_t	data;
} vop_dc_arg_t;

typedef struct _vop_color_temp_arg_t {
	int	error;
	vop_col_temp_t	data;
} vop_color_temp_arg_t;

typedef struct _vop_lut_gamma_block_arg_t {
	int	error;
	unsigned char	onoff;
} vop_lut_gamma_block_arg_t;

typedef struct _vop_lut_arg_t {
	int	error;
	int table_shmid;
} vop_lut_arg_t;

typedef struct _vop_noise_shaping_arg_t {
	int	error;
	vop_ns_t	data;
} vop_noise_shaping_arg_t;

typedef struct _vop_rgbmask_pulse_arg_t {
	int	error;
	unsigned char	onoff;
	vop_pulse_t	main;
	vop_pulse_t	sub;
} vop_rgbmask_pulse_arg_t;

typedef struct _vop_rgbmask_color_arg_t {
	int	error;
	vop_rgb_t	data;
} vop_rgbmask_color_arg_t;

typedef struct _vop_backlight_pwm_arg_t {
	int	error;
	unsigned char target;
	vop_blpwm_t	data;
} vop_backlight_pwm_arg_t;


typedef struct _vop_active_window_arg_t {
	int	error;
	vop_window_t	main;
	vop_window_t	sub;
	vop_actwin_t	mode;
} vop_active_window_arg_t;

typedef struct _vop_intrproc_arg_t {
	int	error;
	vop_intr_t	mode;
} vop_intrproc_arg_t;


typedef struct _vop_probe_arg_t {
	int	error;
	vop_window_t	pos;
	vop_probe_data_t	data;	/* tentative */
	unsigned long	data_num;
} vop_probe_arg_t;

typedef struct _vop_probe_once_arg_t {
	int	error;
	vop_probe_pos_t	pos;
	vop_probe_data_t	data;
} vop_probe_once_arg_t;



typedef struct _vop_signal_form_arg_t {
	int	error;
	vop_signal_form_t	data;
} vop_signal_form_arg_t;

typedef struct _vop_reverse_scan_arg_t {
	int	error;
	unsigned char mode;
} vop_reverse_scan_arg_t;

typedef struct _vop_detect_yhst256_arg_t {
	int	error;
	int yhst_shmid;
} vop_detect_yhst256_arg_t;

typedef struct _vop_ygamma256_arg_t {
	int	error;
	unsigned char	onoff;
	int gamma_shmid;
} vop_ygamma256_arg_t;

typedef struct _vop_ywhite_arg_t {
	int	error;
	unsigned char	onoff;
	vop_ywhite_t	data;
} vop_ywhite_arg_t;

typedef struct _vop_selective_gradation_arg_t {
	int	error;
	unsigned char	onoff;
	vop_seladapt_t	data;
} vop_selective_gradation_arg_t;

typedef struct _vop_selective_enhance_arg_t {
	int	error;
	unsigned char	onoff;
	vop_selenh_t	data;
} vop_selective_enhance_arg_t;

typedef struct _vop_dcnr_arg_t {
	int	error;
	unsigned char	onoff;
	vop_dcnr_t	data;
} vop_dcnr_arg_t;

typedef struct _vop_ld_panel_info_arg_t {
	int	error;
	vopld_panel_info_t	data;
} vop_ld_panel_info_arg_t;

typedef struct _vop_ld_spi_format_arg_t {
	int	error;
	vopld_spi_form_t	data;
} vop_ld_spi_format_arg_t;

typedef struct _vop_ld_control_arg_t {
	int	error;
	unsigned char	onoff;
	vopld_ctrl_t	data;
} vop_ld_control_arg_t;

typedef struct _vop_ld_rgb_effect_arg_t {
	int	error;
	unsigned char	onoff;
	vopld_rgb_t	data;
} vop_ld_rgb_effect_arg_t;

typedef struct _vop_diagonal_ypk_arg_t {
	int	error;
	unsigned char	onoff;
	vop_diag_ypk_t	data;
} vop_diagonal_ypk_arg_t;

typedef struct _vop_od_block_arg_t {
	int	error;
	unsigned char	onoff;
} vop_od_block_arg_t;
typedef struct _vop_freq_hst_arg_t {
	int	error;
	vop_freq_hst_t	data;
} vop_freq_hst_arg_t;

typedef struct _vop_freqhst_param_arg_t {
	int	error;
	vop_freqhst_param_t	data;
} vop_freqhst_param_arg_t;
typedef struct _vop_frc_dither_arg_t {
	int error;
	unsigned char onoff;
	vop_frc_dither_t data;
} vop_frc_dither_arg_t;

typedef struct _vop_frc_dither_lut_arg_t {
	int error;
	vop_frc_dither_lut_t data;
} vop_frc_dither_lut_arg_t;



#endif	/* #ifndef	_VOP_BRIDGE_DATA_H_ */
